# Local Image Hosting Guide

## How to Add Images to Your Pro Rider Website

### 1. Image Folder Structure
Your images are organized in these folders:
```
public/images/
├── tours/          # Tour images
├── gallery/        # Gallery images  
├── guides/         # Guide profile images
└── blog/           # Blog post images
```

### 2. How to Add Images

#### Step 1: Add Image Files
1. Copy your image files to the appropriate folder
2. Use descriptive names: `angkor-wat-tour.jpg`, `guide-john.jpg`
3. Supported formats: `.jpg`, `.jpeg`, `.png`, `.webp`

#### Step 2: Reference Images in Admin Panel
When adding tours, guides, or gallery items, use these paths:
- **Tours**: `/images/tours/tour-name.jpg`
- **Guides**: `/images/guides/guide-name.jpg`
- **Gallery**: `/images/gallery/image-name.jpg`
- **Blog**: `/images/blog/post-name.jpg`

### 3. Example Image Paths
```
/images/tours/angkor-wat-sunrise.jpg
/images/tours/phnom-penh-city-tour.jpg
/images/guides/john-smith.jpg
/images/gallery/cambodia-landscape.jpg
/images/blog/travel-tips-cambodia.jpg
```

### 4. Image Optimization Tips
- **Size**: Keep images under 2MB for fast loading
- **Dimensions**: 1200x800px works well for most images
- **Format**: Use JPEG for photos, PNG for graphics with transparency
- **Compression**: Compress images before adding them

### 5. When You Deploy
- All images in `public/images/` will be included in your build
- Images will be served from your hosting server
- No external dependencies or upload services needed

### 6. Adding Images to Your Project
1. **For Tours**: Put tour photos in `public/images/tours/`
2. **For Guides**: Put guide photos in `public/images/guides/`
3. **For Gallery**: Put gallery photos in `public/images/gallery/`
4. **For Blog**: Put blog images in `public/images/blog/`

### 7. Sample Images
You can start with these sample paths (add the actual image files):
- `/images/tours/sample-tour1.jpg`
- `/images/tours/sample-tour2.jpg`
- `/images/guides/sample-guide1.jpg`
- `/images/gallery/sample-gallery1.jpg`

## Benefits of Local Image Hosting
✅ **No external dependencies** - Everything is self-contained
✅ **Fast loading** - Images served from your server
✅ **No upload complexity** - Just copy files to folders
✅ **No monthly costs** - No image hosting fees
✅ **Full control** - You own all your images
✅ **Easy backup** - Images are part of your project files
